#!/usr/local/bin/python
# coding: utf-8

# für saubere Beendigung im Fehlerfall und allfälliger Rückgabe eines Fehlercodes an Aufrufer (=Sprachassistenten z.B.)
import sys

# wie die Kommandodatei heißen soll:
S_instruction_file = "instruction.txt"

# die derzeit unterstützten Kommandos:

S_all_clear = "alles ok"
S_ambulance = "Rettung"
S_cancel = "Abbruch"
S_fall = "Fall"

# Fehlercodes:

I_IOError=1

# D. Funktion schreibt ein Kommando in die Kommandodatei - der Sinn im eigenständigen Skript ist, dass dieses von Sprachassistenten aufgerufen werden kann, um ein Kommando zu hinterlegen für das Kontrolllogikskript - dort kann nämlich ein input() aus Python nicht erfolgen, da dieser das ganze Skript anhalten würde, was im Ernstfall bei Bewusstlosigkeit der Person zu keinem Notruf führen würde
def create_commandfile(S_command):
	
	# Kommandodatei öffnen und gewünschtes Kommando eintragen
	try:
		file = open(S_instruction_file,"w") 
		file.write(S_command) 
		file.close()
		return True
	# im Fehlerfall melden
	except IOError:
		
		print ("Fehler beim Anlegen der Kommandodatei - create_commandfile")
		# hier kann bedenkenlos sys.exit erfolgen, da es nicht das Kontrolllogikskript ist, sondern das reine Generierungsskript -> im Gegenteil hier soll sogar ein IOError zurückgemeldet werden für den jeweiligen Aufrufer, der diesen auch abfragen sollte und entsrpechend reagieren durch z. B. Wiederholen oder die Person zu informieren
		sys.exit(I_IOError)

# Hauptprogramm:
# jeweiliges Kommando anlegen lassen

# "alles ok" -> keine Reaktion (der Normalfall) -> Kontrolllogikskript wird weiter ausgeführt und wartet auf Ereignisse
# create_commandfile(S_all_clear)

# "Rettung" -> Person verlangt sofort nach Rettung
#create_commandfile(S_ambulance)

# "Fall" -> Person ist (erst mal) gestürzt, was weiter geschieht, entscheidet Kontrolllogikskript
create_commandfile(S_fall)

# "Abbruch" -> Person bricht Alarmstatus / Rettungsruf ab
# create_commandfile(S_cancel)


